define("mod_interactivevideo/player/dailymotion",["exports","core/event_dispatcher","jquery","mod_interactivevideo/player/checkautoplay"],(function(_exports,_event_dispatcher,_jquery,_checkautoplay){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * DailyMotion Player class
   * Documented at https://developers.dailymotion.com/sdk/player-sdk/web/
   * @module     mod_interactivevideo/player/dailymotion
   * @copyright  2024 Sokunthearith Makara <sokunthearithmakara@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */let player;Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_jquery=_interopRequireDefault(_jquery),_checkautoplay=_interopRequireDefault(_checkautoplay);var _default=class{constructor(){this.type="dailymotion",this.frequency=.27,this.support={playbackrate:!0,quality:!0,password:!0},this.useAnimationFrame=!1}async load(url,start,end){let opts=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};const showControls=opts.showControls||!1,customStart=opts.customStart||!1,node=opts.node||"player";this.start=start,this.allowAutoplay=await(0,_checkautoplay.default)(document.getElementById(node)),this.allowAutoplay||(0,_event_dispatcher.dispatchEvent)("iv:autoplayBlocked");const videoId=/(?:https?:\/\/)?(?:www\.)?(?:dai\.ly|dailymotion\.com)\/(?:embed\/video\/|video\/|)([^/]+)/g.exec(url)[1];this.videoId=videoId;var self=this;self.aspectratio=16/9,self.posterImage="",opts.editform&&fetch("https://api.dailymotion.com/video/".concat(videoId,"?fields=thumbnail_720_url")).then((response=>response.json())).then((data=>{self.posterImage=data.thumbnail_720_url})).catch((()=>{}));var ready=!1,dmOptions={video:videoId,params:{startTime:start,mute:!0}};let dailymotion;const dailymotionEvents=async player=>{const state=await player.getState();if(!1===state.playerIsViewable&&0==state.videoDuration)return void(0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:"Video is not viewable."});if(player.off(dailymotion.events.VIDEO_DURATIONCHANGE),state.videoIsPasswordRequired&&0==state.videoDuration||0==state.videoDuration)return void player.on(dailymotion.events.VIDEO_DURATIONCHANGE,(function(){dailymotionEvents(player)}));self.aspectratio=await self.ratio();const totaltime=Number(state.videoDuration.toFixed(2))-self.frequency;end=end?Math.min(end,totaltime):totaltime,end=Number(end.toFixed(2)),self.end=end,self.totaltime=totaltime,self.duration=self.end-self.start,self.title=state.videoTitle,player.setSubtitles(null);let tracks=state.videoSubtitlesList;tracks&&tracks.length>0&&(tracks=tracks.map((track=>{const locale=track.split("-")[0],country=track.split("-")[1];let displayNames,label;try{displayNames=new Intl.DisplayNames(["".concat(M.cfg.language)],{type:"language"})}catch(e){displayNames=new Intl.DisplayNames(["en"],{type:"language"})}var _displayNames$of;"auto"==country?label=displayNames.of(locale)+" (Auto)":label=null!==(_displayNames$of=displayNames.of(track))&&void 0!==_displayNames$of?_displayNames$of:track.toUpperCase();return{label:label,code:track}})),self.captions=tracks),(0,_event_dispatcher.dispatchEvent)("iv:playerLoaded",{tracks:tracks,qualities:self.getQualities()}),state.playerIsPlaybackAllowed||ready||(self.paused=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node)),(0,_jquery.default)("#start-screen #play").removeClass("d-none"),(0,_jquery.default)("#start-screen #spinner").remove(),(0,_jquery.default)(".video-block, #video-block").addClass("no-pointer bg-transparent"),(0,_jquery.default)("#annotation-canvas").removeClass("d-none w-0"));const playerEvents=()=>{player.on(dailymotion.events.VIDEO_END,(function(){self.ended=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded")})),player.off(dailymotion.events.VIDEO_TIMECHANGE),player.on(dailymotion.events.VIDEO_TIMECHANGE,(async function(e){ready&&(e.videoTime<start&&player.seek(start),e.videoTime>end+self.frequency&&player.seek(end-1),self.ended?((0,_event_dispatcher.dispatchEvent)("iv:playerEnded"),self.ended=!1):(!0===e.playerIsPlaying&&((0,_event_dispatcher.dispatchEvent)("iv:playerPlaying"),self.ended=!1,self.paused=!1),e.videoTime>=end&&((0,_event_dispatcher.dispatchEvent)("iv:playerEnded"),self.ended=!0)))})),player.off(dailymotion.events.VIDEO_PLAY),player.on(dailymotion.events.VIDEO_PLAY,(async function(e){(self.ended||e.videoTime>=end)&&(self.ended=!1,player.seek(start)),self.paused=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerPlay")})),player.on(dailymotion.events.VIDEO_PAUSE,(async function(){ready&&(self.paused=!0,player.getState().videoTime>=end?(self.ended=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded")):(0,_event_dispatcher.dispatchEvent)("iv:playerPaused"))})),player.on(dailymotion.events.PLAYER_ERROR,(function(e){(0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:e})})),player.on(dailymotion.events.PLAYER_PLAYBACKSPEEDCHANGE,(function(e){(0,_event_dispatcher.dispatchEvent)("iv:playerRateChange",{rate:e.playerPlaybackSpeed})})),player.on(dailymotion.events.VIDEO_QUALITYCHANGE,(function(e){(0,_event_dispatcher.dispatchEvent)("iv:playerQualityChange",{quality:e.videoQuality})}))};customStart?(player.setMute(!0),player.play(),self.paused=!1,player.on(dailymotion.events.VIDEO_PLAY,(function(){(0,_event_dispatcher.dispatchEvent)("iv:playerPlay")})),player.on(dailymotion.events.VIDEO_TIMECHANGE,(function(){(0,_jquery.default)("#start-screen").removeClass("bg-transparent"),1==ready&&player.setMute(!0),setTimeout((async()=>{state.playerIsPlaybackAllowed&&player.pause(),player.seek(start),player.setMute(!1),ready||(playerEvents(),ready=!0,state.playerIsPlaybackAllowed&&(0,_event_dispatcher.dispatchEvent)("iv:playerReady"))}),state.playerIsPlaybackAllowed?1e3:0)}))):(playerEvents(),ready=!0,state.playerIsPlaybackAllowed&&(0,_event_dispatcher.dispatchEvent)("iv:playerReady")),player.on(dailymotion.events.AD_START,(function(){(0,_jquery.default)(".video-block, #video-block").addClass("d-none"),(0,_jquery.default)("#start-screen").addClass("d-none"),(0,_jquery.default)("#annotation-canvas").removeClass("d-none w-0")})),player.on(dailymotion.events.AD_END,(function(){(0,_jquery.default)(".video-block, #video-block").removeClass("d-none"),(0,_jquery.default)("#start-screen").removeClass("d-none")}))};if(window.dailymotion)player=await window.dailymotion.createPlayer(node,dmOptions),dailymotionEvents(player),dailymotion=window.dailymotion;else{var tag=document.createElement("script");showControls||opts.passwordprotected?tag.src="https://geo.dailymotion.com/libs/player/xsyje.js":tag.src="https://geo.dailymotion.com/libs/player/xsyj8.js";var firstScriptTag=document.getElementsByTagName("script")[0];firstScriptTag.parentNode.insertBefore(tag,firstScriptTag),window.dailymotion={onScriptLoaded:async()=>{dailymotion=window.dailymotion,player=await dailymotion.createPlayer(node,dmOptions),dailymotionEvents(player)}}}}play(){player.play(),this.paused=!1}async pause(){return!this.paused&&(await player.pause(),this.paused=!0,!0)}stop(starttime){player.seek(starttime),player.pause()}async seek(time){await player.seek(time),this.ended=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerSeek",{time:time})}async getCurrentTime(){return(await player.getState()).videoTime}async getDuration(){return(await player.getState()).videoDuration}async isPaused(){if(this.paused)return!0;return!(await player.getState()).playerIsPlaying}async isPlaying(){if(this.paused)return!1;return(await player.getState()).playerIsPlaying}async isEnded(){if(this.ended)return!0;return(await player.getState()).playerIsReplayScreen}async ratio(){const ratio=(await player.getState()).playerAspectRatio.split(":");return ratio[0]/ratio[1]}destroy(){player.off(),player.destroy()}async getState(){return await player.getState()}setRate(rate){player.setPlaybackSpeed(rate)}mute(){player.setMute(!0)}unMute(){player.setMute(!1),player.setVolume(1)}async isMuted(){return(await player.getState()).playerIsMuted}originalPlayer(){return player}setQuality(quality){player.setQuality(quality)}async getQualities(){let states=await this.getState();return{qualities:["default",...states.videoQualitiesList],qualitiesLabel:["Auto",...states.videoQualitiesList],currentQuality:"Auto"==states.videoQuality?"default":states.videoQuality}}setCaption(track){player.setSubtitles(track)}};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=dailymotion.min.js.map