define("mod_interactivevideo/player/kinescope",["exports","core/event_dispatcher","jquery","mod_interactivevideo/player/checkautoplay"],(function(_exports,_event_dispatcher,_jquery,_checkautoplay){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Kinescope Player class
   *
   * @module     mod_interactivevideo/player/kinescope
   * @copyright  2024 Sokunthearith Makara <sokunthearithmakara@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */let player;Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_jquery=_interopRequireDefault(_jquery),_checkautoplay=_interopRequireDefault(_checkautoplay);var _default=class{constructor(){this.type="kinescope",this.useAnimationFrame=!1,this.support={playbackrate:!0,quality:!0,password:!0},this.frequency=.3}async load(url,start,end){let opts=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};const showControls=opts.showControls||!1,node=opts.node||"player";this.node=node,this.start=start,this.allowAutoplay=await(0,_checkautoplay.default)(document.getElementById(node)),this.allowAutoplay||(0,_event_dispatcher.dispatchEvent)("iv:autoplayBlocked");let videoId=/kinescope\.io\/(.*)/.exec(url)[1];this.videoId=videoId;let ready=!1,self=this;self.aspectratio=16/9;const playerEvents=function(playerFactory){playerFactory.create("player",{url:"https://kinescope.io/"+videoId,behaviour:{playsInline:!0,keyboard:!1,localStorage:!1,preload:!0},ui:{controls:showControls}}).then((function(pl){pl.on(pl.Events.Ready,(async function(event){player=event.target;let totaltime=Number(event.data.duration.toFixed(2))-self.frequency;end=end?Math.min(end,totaltime):totaltime,end=Number(end.toFixed(2)),self.aspectratio=event.data.aspectRatio.ratio,self.end=end,self.totaltime=Number(totaltime.toFixed(2)),self.duration=self.end-self.start,self.texttracks=event.data.textTracks,self.qualities=event.data.qualities,player.disableTextTrack();let tracks=[];if(self.texttracks.length>0&&(self.texttracks.forEach((track=>{tracks.push({label:track.label,code:track.language})})),self.captions=tracks),(0,_event_dispatcher.dispatchEvent)("iv:playerLoaded",{tracks:tracks,qualities:self.getQualities()}),opts.editform){const response=await fetch(url),data=await response.text();let doc=(new DOMParser).parseFromString(data,"text/html"),page=(0,_jquery.default)(doc),title=page.find('meta[property="og:title"]').attr("content"),poster=page.find('meta[property="og:image"]').attr("content");self.title=title,self.posterImage=poster}await player.seekTo(start),await player.pause(),ready=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node))})),pl.on(pl.Events.Play,(async function(event){if(!ready)return;self.paused=!1,self.ended=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerPlay");await player.getCurrentTime()>=end&&(self.ended=!0,self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded"))})),pl.on(pl.Events.Pause,(async function(event){ready&&(self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerPaused"))})),pl.on(pl.Events.Ended,(function(event){ready&&(self.ended=!0,self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded"))})),pl.on(pl.Events.TimeUpdate,(async function(event){if(!ready)return;let currentTime=await player.getCurrentTime();currentTime<start&&(await player.seekTo(start),self.ended=!1),currentTime>end+self.frequency?await player.seekTo(end-self.frequency):currentTime>=end?(self.ended=!0,await player.seekTo(end),(0,_event_dispatcher.dispatchEvent)("iv:playerEnded")):self.paused||(self.paused=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerPlaying"))})),pl.on(pl.Events.QualityChanged,(async function(event){ready&&(0,_event_dispatcher.dispatchEvent)("iv:playerQualityChange",{quality:event.quality})})),pl.on(pl.Events.PlaybackRateChange,(async function(event){ready&&(0,_event_dispatcher.dispatchEvent)("iv:playerSpeedChange",{rate:event.playbackRate})})),pl.on(pl.Events.Waiting,(async function(event){ready&&(0,_event_dispatcher.dispatchEvent)("iv:playerBuffering")}))}))};if(window.Kinescope)(0,_jquery.default)("#video-wrapper").html('<iframe id="player"></iframe>'),playerEvents(window.playerFactory);else{var tag=document.createElement("script");tag.src="https://player.kinescope.io/latest/iframe.player.js",tag.async=!0,tag.as="script",tag.rel="preload";var firstScriptTag=document.getElementsByTagName("script")[0];firstScriptTag.parentNode.insertBefore(tag,firstScriptTag),window.onKinescopeIframeAPIReady=async function(playerFactory){window.playerFactory=playerFactory,playerEvents(playerFactory)}}}async play(){await player.play(),this.paused=!1}async pause(){await player.pause(),this.paused=!0}stop(starttime){player.seekTo(starttime),player.pause()}seek(time){return time<0&&(time=0),this.ended=!1,player.seekTo(parseFloat(time)),(0,_event_dispatcher.dispatchEvent)("iv:playerSeek",{time:time}),time}async getCurrentTime(){return await player.getCurrentTime()}async getDuration(){return await player.getDuration()}async isPaused(){if(this.paused)return!0;return await player.isPaused()}async isPlaying(){if(this.paused)return!1;return!await player.isPaused()}async isEnded(){if(this.ended)return!0;return await player.isEnded()}async ratio(){return this.aspectratio}async destroy(){player?(player.off(),await player.destroy()):(0,_jquery.default)("#".concat(this.node)).remove()}async getState(){return await player.isPaused()?"paused":"playing"}setRate(rate){player.setPlaybackRate(rate)}mute(){player.mute()}unMute(){player.unmute(),player.setVolume(1)}isMuted(){return player.isMuted()}async setQuality(quality){return await player.setVideoQuality(quality),quality}async getQualities(){let qualities=await player.getVideoQualityList();return{qualities:qualities,qualitiesLabel:qualities.map((x=>"auto"==x?"Auto":x)),currentQuality:await player.getCurrentVideoQuality()}}async setCaption(language){return"off"===language||""===language?await player.disableTextTrack():await player.enableTextTrack(language),language}originalPlayer(){return player}};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=kinescope.min.js.map