define("mod_interactivevideo/player/panopto",["exports","core/event_dispatcher","jquery","core/str","mod_interactivevideo/player/checkautoplay"],(function(_exports,_event_dispatcher,_jquery,_str,_checkautoplay){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Panopto Player class
   *
   * @module     mod_interactivevideo/player/panopto
   * @copyright  2024 Sokunthearith Makara <sokunthearithmakara@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */var player;Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_jquery=_interopRequireDefault(_jquery),_checkautoplay=_interopRequireDefault(_checkautoplay);var _default=class{constructor(){this.useAnimationFrame=!0,this.type="panopto",this.frequency=.25,this.support={playbackrate:!0,quality:!1}}async load(url,start,end){let opts=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{},showControls=opts.showControls||!1;const node=opts.node||"player";var EmbedApi;this.allowAutoplay=await(0,_checkautoplay.default)(document.getElementById(node)),this.allowAutoplay||(0,_event_dispatcher.dispatchEvent)("iv:autoplayBlocked",{requireVideoBlock:!0}),this.start=start,this.end=end;const matches=url.match(/^[^/]+:\/\/([^/]*panopto\.[^/]+)\/Panopto\/.+\?id=(.+)$/),serverName=matches[1],sessionId=matches[2];var ready=!1,self=this;self.aspectratio=16/9;let autoplayBlocked=!1;var options={sessionId:sessionId,serverName:serverName,width:1080,height:720,videoParams:{interactivity:"none",showtitle:!1,autohide:!0,offerviewer:!1,autoplay:!0,showbrand:!1,start:start,hideoverlay:!showControls},events:{onReady:function(){ready||(player.muteVideo(),player.pauseVideo(),function(){player.unmuteVideo(),player.setVolume(1);let totaltime=Number(player.getDuration().toFixed(2))-self.frequency;if(end=end?Math.min(end,totaltime):totaltime,end=Number(end.toFixed(2)),self.end=end,self.totaltime=totaltime,self.duration=self.end-self.start,opts.editform)_jquery.default.ajax({url:M.cfg.wwwroot+"/mod/interactivevideo/ajax.php",type:"POST",dataType:"text/plain",data:{action:"get_from_url",contextid:M.cfg.contextid,url:url,sesskey:M.cfg.sesskey},complete:function(res){let doc=(new DOMParser).parseFromString(res.responseText,"text/html"),page=(0,_jquery.default)(doc),title=page.find('meta[property="og:title"]').attr("content"),poster=page.find('meta[property="og:image"]').attr("content");self.title=title,self.posterImage=poster,ready||(ready=!0,autoplayBlocked||(autoplayBlocked=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node))),showControls||(0,_jquery.default)(".video-block, #video-block").removeClass("no-pointer"))}});else{let tracks=player.getCaptionTracks();player.disableCaptions(),tracks&&tracks.length>0&&(tracks=tracks.map(((track,i)=>({label:track,code:"code-"+i}))),(0,_event_dispatcher.dispatchEvent)("iv:playerLoaded",{tracks:tracks})),ready||(ready=!0,autoplayBlocked||(autoplayBlocked=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node))),showControls||(0,_jquery.default)(".video-block, #video-block").removeClass("no-pointer"))}}())},onIframeReady:async function(){player.muteVideo(),player.loadVideo(),player.pauseVideo()},onStateChange:function(state){if(!1!==ready)switch(state){case PlayerState.Ended:self.ended=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded");break;case PlayerState.Playing:(player.getCurrentTime()>=self.end||player.getCurrentTime()<self.start)&&player.seekTo(self.start),(0,_event_dispatcher.dispatchEvent)("iv:playerPlay"),(0,_event_dispatcher.dispatchEvent)("iv:playerPlaying"),self.ended=!1,this.paused=!1;break;case PlayerState.Paused:if(this.paused=!0,!self.ended&&player.getCurrentTime()>=self.end-self.frequency)return(0,_event_dispatcher.dispatchEvent)("iv:playerEnded"),void(self.ended=!0);(0,_event_dispatcher.dispatchEvent)("iv:playerPaused"),self.ended=!1}else player.pauseVideo()},onPlaybackRateChange:function(e){(0,_event_dispatcher.dispatchEvent)("iv:playerRateChange",{rate:e})},onError:async function(error){if("playNotAllowed"!==error)"playWithSoundNotAllowed"!==error?(0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:error}):ready||player.muteVideo();else if((0,_jquery.default)("#start-screen #play").removeClass("d-none"),(0,_jquery.default)("#start-screen #spinner").remove(),(0,_jquery.default)(".video-block, #video-block").addClass("no-pointer bg-transparent"),(0,_jquery.default)("#annotation-canvas").removeClass("d-none w-0"),opts.editform){if(!ready){const errorString=await(0,_str.getString)("errorplaynotallowed","mod_interactivevideo");(0,_jquery.default)("#video-wrapper").after('<div class="noautoplay small text-danger mt-n3 mb-3">'.concat(errorString,"</div>"))}}else autoplayBlocked||(autoplayBlocked=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node)))},onLoginShown:function(){(0,_jquery.default)("#start-screen").addClass("d-none"),(0,_jquery.default)(".video-block, #video-block").addClass("no-pointer bg-transparent"),(0,_jquery.default)("#annotation-canvas").removeClass("d-none w-0")}}};if(window.EmbedApi)player=new window.EmbedApi(node,options);else{var tag=document.createElement("script");tag.src="https://developers.panopto.com/scripts/embedapi.min.js",tag.type="text/javascript";var firstScriptTag=document.getElementsByTagName("script")[0];firstScriptTag.parentNode.insertBefore(tag,firstScriptTag),window.onPanoptoEmbedApiReady=function(){EmbedApi=window.EmbedApi,player=new EmbedApi(node,options)}}}play(){player.playVideo(),this.paused=!1}pause(){player.pauseVideo(),this.paused=!0}stop(starttime){player.seekTo(starttime),player.pauseVideo()}async seek(time){return this.ended=!1,new Promise((resolve=>{player.seekTo(time,!0),(0,_event_dispatcher.dispatchEvent)("iv:playerSeek",{time:time}),resolve(!0)}))}getCurrentTime(){return player.getCurrentTime()}getDuration(){return player.getDuration()}isPaused(){return!!this.paused||player.getState()==PlayerState.Paused}isPlaying(){return!this.paused&&player.getState()==PlayerState.Playing}isEnded(){return!!this.ended||(player.getState()==PlayerState.Ended||player.getCurrentTime()>=this.end)}ratio(){return 16/9}destroy(){player=null,(0,_jquery.default)("#player").remove(),(0,_event_dispatcher.dispatchEvent)("iv:playerDestroyed")}getState(){return 1===player.getState()?"playing":2===player.getState()?"paused":"stopped"}setRate(rate){return player.setPlaybackRate(rate),rate}mute(){player.muteVideo()}unMute(){player.unmuteVideo(),player.setVolume(1)}isMuted(){return player.isMuted()}originalPlayer(){return player}setCaption(track){!1!==player.hasCaptions()&&(track&&""!==track?(track=track.replace("code-",""),player.enableCaptions(track)):player.disableCaptions())}};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=panopto.min.js.map