define("mod_interactivevideo/player/peertube",["exports","core/event_dispatcher","jquery","mod_interactivevideo/libraries/peertube","mod_interactivevideo/player/checkautoplay"],(function(_exports,_event_dispatcher,_jquery,_peertube,_checkautoplay){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * PeerTube Player class
   * https://docs.joinpeertube.org/api/embed-player#embed-methods
   *
   * @module     mod_interactivevideo/player/peertube
   * @copyright  2024 Sokunthearith Makara <sokunthearithmakara@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */let player;Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_jquery=_interopRequireDefault(_jquery),_checkautoplay=_interopRequireDefault(_checkautoplay);var _default=class{constructor(){this.useAnimationFrame=!1,this.type="peertube",this.frequency=.7,this.support={playbackrate:!0,quality:!0,password:!0}}async load(url,start,end){let opts=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};const showControls=opts.showControls||!1,node=opts.node||"player";this.start=start,this.node=node,this.allowAutoplay=await(0,_checkautoplay.default)(document.getElementById(node)),this.allowAutoplay||((0,_event_dispatcher.dispatchEvent)("iv:autoplayBlocked"),(0,_jquery.default)("#video-block, .video-block").remove());const match=url.match(/https:\/\/([^/]+)\/w\/([^/]+)/),domain=match[1];let videoId=match[2].split("?")[0],password=url.split("?password=")[1];const myHeaders=new Headers;password&&""!==password&&myHeaders.append("x-peertube-video-password",password);let videoInfo=await fetch("https://".concat(domain,"/api/v1/videos/").concat(videoId),{method:"GET",headers:myHeaders});if(videoInfo=await videoInfo.json(),"video_requires_password"===videoInfo.code||"incorrect_video_password"===videoInfo.code){let string="video_requires_password"===videoInfo.code?"This video is password protected":"Incorrect password";const pwd=window.prompt(string,"");return null===pwd||(url=url.split("?password=")[0],this.load(url+"?password="+pwd,start,end,opts)),!1}if(!videoInfo.duration)return alert("The video is not available"),!1;let self=this,ready=!1,videoFile=videoInfo.files.pop();if(this.aspectratio=16/9,videoFile){(0,_jquery.default)("<video>").attr("src",videoFile.fileDownloadUrl).attr("preload","metadata").on("loadedmetadata",(function(){self.aspectratio=this.videoWidth/this.videoHeight}))}const totaltime=Number(videoInfo.duration.toFixed(2))-self.frequency;end=end?Math.min(end,totaltime):totaltime,end=Number(end.toFixed(2)),self.end=end,self.totaltime=totaltime,self.duration=self.end-self.start,self.title=videoInfo.name,self.videoId=videoInfo.uuid,self.posterImage="https://"+domain+videoInfo.thumbnailPath;let iframeURL="https://".concat(domain).concat(videoInfo.embedPath,"?api=1&autoplay=1&end=").concat(end,"&start=").concat(start);iframeURL+="&warningTitle=0&controls=".concat(showControls||!self.allowAutoplay?1:0,"&peertubeLink=0&p2p=0&muted=0&controlBar=").concat(showControls?1:0,"&title=0"),password&&""!==password&&(iframeURL+="&waitPasswordFromEmbedAPI=1"),(0,_jquery.default)("#".concat(node)).replaceWith('<iframe id="'.concat(node,'" src="').concat(iframeURL,'" width="100%" height="100%" allow="autoplay"\n             frameborder="0" allowfullscreen="" sandbox="allow-same-origin allow-scripts allow-popups allow-forms"></iframe>')),player=new _peertube.PeerTubePlayer(document.getElementById(node)),player.setVideoPassword(password),await player.ready,player.pause(),player.setVolume(0),player.seek(start);let captions=await player.getCaptions();captions.length>0&&(captions=captions.map((caption=>({label:caption.label,code:caption.id})))),(0,_event_dispatcher.dispatchEvent)("iv:playerLoaded",{tracks:captions,qualities:self.getQualities()});return player.addEventListener("playbackStatusChange",(status=>{ready?"paused"===status?(self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerPaused")):"playing"===status&&(self.paused=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerPlay")):player.setVolume(0)})),player.addEventListener("playbackStatusUpdate",(status=>{if(!self.ended)if(ready)(status=>{let currentTime=status.position;switch(self.currentTime=currentTime,status.playbackState){case"playing":self.paused=!1,self.ended=!1,currentTime<self.start&&self.seek(self.start),(0,_event_dispatcher.dispatchEvent)("iv:playerPlaying"),currentTime>=self.end&&(self.ended=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded"));break;case"ended":self.ended||(self.ended=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded")),self.paused=!0}})(status);else{player.setVolume(0);const goToStart=setInterval((()=>{(status.position>self.start||status.position>=self.end||status.position<=self.start)&&(clearInterval(goToStart),player.seek(self.start),player.pause(),ready=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node)),player.setVolume(1))}),100)}})),!0}async getQualities(){let qualities=await player.getResolutions();return 0!==qualities.length&&{qualities:qualities.map((q=>q.id)),qualitiesLabel:qualities.map((q=>q.label)),currentQuality:qualities.find((q=>q.active)).id}}async setQuality(quality){return await player.setResolution(quality),quality}play(){player.play(),this.paused=!1}pause(){return player.pause(),this.paused=!0,!0}stop(starttime){player.seek(starttime),player.pause()}async seek(time){return this.ended=!1,await player.seek(time),(0,_event_dispatcher.dispatchEvent)("iv:playerSeek",{time:time}),!0}getCurrentTime(){return this.currentTime}async getDuration(){return this.totaltime}async isPaused(){return this.paused}async isPlaying(){return!this.paused}isEnded(){return!!this.ended||this.currentTime>=this.end}ratio(){return this.aspectratio}destroy(){(0,_jquery.default)("#".concat(this.node)).remove(),player.removeEventListener(),(0,_event_dispatcher.dispatchEvent)("iv:playerDestroyed")}getState(){return this.isPaused()?"paused":"playing"}async setRate(rate){return await player.setPlaybackRate(rate),rate}mute(){player.setVolume(0)}unMute(){player.setVolume(1)}async isMuted(){return 0===await player.getVolume()}originalPlayer(){return player}async setCaption(track){await player.setCaption(track)}};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=peertube.min.js.map