define("mod_interactivevideo/player/rumble",["exports","jquery","core/event_dispatcher","mod_interactivevideo/player/checkautoplay"],(function(_exports,_jquery,_event_dispatcher,_checkautoplay){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Rumble Player class
   * Doc: https://www.rumbleplayer.com/developers/Player-Methods.html
   *
   * @module     mod_interactivevideo/player/rumble
   * @copyright  2024 Sokunthearith Makara <sokunthearithmakara@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */var player;Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_jquery=_interopRequireDefault(_jquery),_checkautoplay=_interopRequireDefault(_checkautoplay);var _default=class{constructor(){this.type="rumble",this.useAnimationFrame=!0,this.frequency=.1,this.support={playbackrate:!1,quality:!1,password:!1}}async load(url,start,end){let opts=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};const showControls=opts.showControls||!1,node=opts.node||"player";this.node=node,this.start=start,this.allowAutoplay=await(0,_checkautoplay.default)(document.getElementById(node)),this.allowAutoplay||(0,_event_dispatcher.dispatchEvent)("iv:autoplayBlocked"),(0,_jquery.default)("#start-screen, .video-block").addClass("no-pointer");let ready=!1,firstAPIrun=!1,self=this;self.ended="unknown",self.paused="unknown";let oEmbed="https://rumble.com/api/Media/oembed.json?url="+encodeURIComponent(url);_jquery.default.ajax({url:M.cfg.wwwroot+"/mod/interactivevideo/ajax.php",type:"POST",data:{action:"get_from_url",contextid:M.cfg.contextid,url:oEmbed,sesskey:M.cfg.sesskey}}).done((function(data){firstAPIrun=!1,self.title=data.title,self.aspectratio=data.width/data.height,self.posterImage=data.thumbnail_url;let totaltime=Number(data.duration).toFixed(2)-self.frequency;end=end&&0!=end?Math.min(end,totaltime):totaltime,end=Number(end).toFixed(2),self.end=end,self.totaltime=totaltime,self.duration=self.end-self.start;let videoId=(0,_jquery.default)(data.html).attr("src").match(/embed\/([a-zA-Z0-9]+)/)[1];videoId=videoId.split("/")[0],self.videoId=videoId;var tag=document.createElement("script");tag.src="https://rumble.com/embedJS/"+videoId;var firstScriptTag=document.getElementsByTagName("script")[0];firstScriptTag.parentNode.insertBefore(tag,firstScriptTag),tag.onload=async()=>{let id=videoId.split(".")[1]?videoId.split(".")[1]:videoId;window.Rumble("play",{video:id,div:node,rel:0,autoplay:2,ui:{logo:{hidden:!0},fullscreen:{hidden:!0},autoplay:{hidden:!0}},api:function(api){(player=api).mute(),showControls||(0,_jquery.default)("body").addClass("no-original-controls"),firstAPIrun||(player.setCurrentTime(start),ready=!0,firstAPIrun=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node))),(0,_jquery.default)(document).on("timeupdate",(function(){ready&&(player.getCurrentTime()<start&&player.setCurrentTime(start),player.getCurrentTime()>=end+self.frequency&&player.setCurrentTime(end-self.frequency))})),api.on("play",(function(){ready&&(self.paused=!1,player.getCurrentTime()<start&&player.setCurrentTime(start),self.ended&&player.getCurrentTime()>=end&&(player.setCurrentTime(start),player.play(),self.ended=!1),self.ended=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerPlay"),(0,_event_dispatcher.dispatchEvent)("iv:playerPlaying"),showControls||(0,_jquery.default)("body").hasClass("no-original-controls")||(0,_jquery.default)("body").addClass("no-original-controls"))})),api.on("pause",(()=>{if(ready&&!self.ended){if(self.paused=!0,player.getCurrentTime()>=end)return self.ended=!0,void(0,_event_dispatcher.dispatchEvent)("iv:playerEnded");(0,_event_dispatcher.dispatchEvent)("iv:playerPaused")}})),api.on("videoEnd",(()=>{ready&&(self.ended=!0,self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded"))}))}})}}))}play(){player.play(),this.paused=!1}pause(){return player.pause(),this.paused=!0,!0}stop(starttime){player.pause(),player.setCurrentTime(starttime)}seek(time){return time=parseFloat(time),new Promise((resolve=>{time<0&&(time=0),this.ended=!1,player.setCurrentTime(time),(0,_event_dispatcher.dispatchEvent)("iv:playerSeek",{time:time}),resolve(time)}))}getCurrentTime(){return player.getCurrentTime()}getDuration(){return player.getDuration()}isPaused(){return this.paused&&player.getPaused()}isPlaying(){return!this.paused}isEnded(){return this.ended||player.getCurrentTime()>=this.end}async ratio(){return this.aspectratio}destroy(){try{(0,_jquery.default)("#".concat(this.node)).remove()}catch(e){window.console.error(e)}}async getState(){return this.paused?"paused":"playing"}setRate(){}mute(){player.mute(),this.muted=!0}unMute(){player.unmute(),player.setVolume(1),this.muted=!1}isMuted(){return this.muted}originalPlayer(){return player}setQuality(){}getQualities(){return null}setCaption(track){return track}};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=rumble.min.js.map