define("mod_interactivevideo/player/vimeo",["exports","core/event_dispatcher","mod_interactivevideo/player/checkautoplay"],(function(_exports,_event_dispatcher,_checkautoplay){var obj;
/**
   * Vimeo Player class
   *
   * @module     mod_interactivevideo/player/vimeo
   * @copyright  2024 Sokunthearith Makara <sokunthearithmakara@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */let player;Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_checkautoplay=(obj=_checkautoplay)&&obj.__esModule?obj:{default:obj};var _default=class{constructor(){this.type="vimeo",this.useAnimationFrame=!1,this.frequency=.27,this.support={playbackrate:!0,quality:!0,password:!0}}async load(url,start,end){let opts=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{},showControls=opts.showControls||!1;const node=opts.node||"player";let VimeoPlayer;this.allowAutoplay=await(0,_checkautoplay.default)(document.getElementById(node)),this.allowAutoplay||(0,_event_dispatcher.dispatchEvent)("iv:autoplayBlocked"),this.start=start,this.aspectratio=16/9;var posterUrl="https://vimeo.com/api/oembed.json?url="+encodeURIComponent(url);const oEmbed=await fetch(posterUrl);if(!oEmbed.ok)return void(0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:"Video not found"});document.getElementById("video-wrapper").style.display="block";const oEmbedData=await oEmbed.json();(403===oEmbedData.domain_status_code||oEmbedData.error)&&(0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:"Video not found"}),this.posterImage=oEmbedData.thumbnail_url||"",this.title=oEmbedData.title,this.videoId=oEmbedData.video_id,this.posterImage=this.posterImage.replace(/_\d+x\d+/,"_720x405"),this.aspectratio=oEmbedData.width/oEmbedData.height;let self=this;const option={url:url,width:1080,height:720,autoplay:!showControls,controls:showControls,loop:!1,muted:!0,playsinline:!0,background:!1,byline:!1,portrait:!1,title:!1,transparent:!1,responsive:!1,start_time:start,end_time:end,pip:!1,fullscreen:!1,watch_full_video:!1,keyboard:!1,dnt:!0,chapters:showControls,interactive_markers:showControls,vimeo_logo:!1,initial_quality:"360p"};let ready=!1;const vimeoEvents=player=>{player.on("loaded",(async function(){let duration=0;try{duration=await player.getDuration()}catch(e){return}if(duration>0){end=end?Math.min(end,duration-.1):duration-.1,end=Number(end.toFixed(2)),self.end=end,self.duration=self.end-self.start,self.totaltime=Number((duration-.1).toFixed(2)),self.title=await player.getVideoTitle(),player.disableTextTrack();let tracks=await player.getTextTracks();tracks&&tracks.length>0&&(tracks=tracks.map((track=>({label:track.label,code:track.language})))),opts.passwordprotected||(0,_event_dispatcher.dispatchEvent)("iv:playerLoaded",{tracks:tracks,qualities:self.getQualities()}),ready=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node)),player.setVolume(1)}else{document.getElementById("video-wrapper").style.display="block";const startScreen=document.getElementById("start-screen");startScreen&&startScreen.classList.add("d-none");const videoBlock=document.querySelector(".video-block");videoBlock&&videoBlock.classList.add("no-pointer","bg-transparent");const annotationCanvas=document.getElementById("annotation-canvas");annotationCanvas&&annotationCanvas.classList.remove("d-none","w-0")}})),showControls||player.on("play",(async function(){ready||(await player.pause(),player.setCurrentTime(start),player.setVolume(1),ready=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node)))})),player.off("play"),player.on("play",(function(){ready&&(self.paused=!1,self.ended=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerPlay"))})),player.on("pause",(function(e){ready&&(self.paused=!0,e.seconds>=end?(self.ended=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded")):(self.ended=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerPaused")))})),player.on("timeupdate",(async function(e){ready&&(e.seconds>=end?(self.ended=!0,self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded")):await player.getPaused()?(self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerPaused")):(self.paused=!1,self.ended=!1,(0,_event_dispatcher.dispatchEvent)("iv:playerPlaying")))})),player.on("playbackratechange",(function(e){ready&&(0,_event_dispatcher.dispatchEvent)("iv:playerRateChange",{rate:e.playbackRate})})),player.on("ended",(function(){ready&&(self.ended=!0,self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded"))})),player.on("qualitychange",(function(e){ready&&(0,_event_dispatcher.dispatchEvent)("iv:playerQualityChange",{quality:e.quality})})),player.on("error",(function(e){if("NotAllowedError"!==e.name&&"appendVideoMetadata"!==e.method&&((0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:e.message}),!showControls)){const $videoblock=document.querySelector(".video-block");$videoblock&&$videoblock.classList.remove("no-pointer")}}))};if(VimeoPlayer)player=new VimeoPlayer(node,option),vimeoEvents(player);else try{require(["https://player.vimeo.com/api/player.js"],(function(Player){VimeoPlayer=Player,player=new Player(node,option),vimeoEvents(player)}))}catch(e){return void(0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:e.message})}}play(){player.play(),this.paused=!1}async pause(){return await player.pause(),this.paused=!0,!0}stop(starttime){player.setCurrentTime(starttime),player.pause()}async seek(time){return time<0&&(time=0),this.ended=!1,await player.setCurrentTime(time),(0,_event_dispatcher.dispatchEvent)("iv:playerSeek",{time:time}),time}async getCurrentTime(){return player.getCurrentTime()}async getDuration(){return await player.getDuration()}async isPaused(){if(this.paused)return!0;return await player.getPaused()}async isPlaying(){if(this.paused)return!1;return!await player.getPaused()}async isEnded(){if(this.ended)return!0;return await player.getEnded()}async ratio(){return await player.getVideoWidth()/await player.getVideoHeight()}destroy(){player&&player.destroy()}async getState(){return await player.getPaused()?"paused":"playing"}setRate(rate){player.setPlaybackRate(rate)}mute(){player.setVolume(0)}unMute(){player.setVolume(1)}async isMuted(){return 0===await player.getVolume()}setQuality(quality){return player.setQuality(quality),quality}async getQualities(){let qualities=await player.getQualities();return{qualities:qualities.map((x=>x.id)),qualitiesLabel:qualities.map((x=>x.label)),currentQuality:qualities.find((x=>x.active)).id}}setCaption(track){""!=track?player.enableTextTrack(track):player.disableTextTrack()}originalPlayer(){return player}};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=vimeo.min.js.map