define("mod_interactivevideo/player/yt",["exports","core/event_dispatcher","jquery","mod_interactivevideo/player/checkautoplay"],(function(_exports,_event_dispatcher,_jquery,_checkautoplay){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Youtube Player class
   * Documented at https://developers.google.com/youtube/iframe_api_reference
   *
   * @module     mod_interactivevideo/player/yt
   * @copyright  2024 Sokunthearith Makara <sokunthearithmakara@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */let player;Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_jquery=_interopRequireDefault(_jquery),_checkautoplay=_interopRequireDefault(_checkautoplay);var _default=class{constructor(){this.useAnimationFrame=!0,this.type="yt",this.frequency=.25,this.support={playbackrate:!0,quality:!1,password:!0},this.live=!1}async load(url,start,end){let opts=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};const showControls=opts.showControls||!1,customStart=opts.customStart||!1,preload=opts.preload||!1,node=opts.node||"player";var YT;(0,_jquery.default)("#video-wrapper").addClass("d-none"),this.allowAutoplay=await(0,_checkautoplay.default)(document.getElementById(node)),this.allowAutoplay||(0,_event_dispatcher.dispatchEvent)("iv:autoplayBlocked",{requireVideoBlock:!0}),this.start=start,this.end=end;var videoId=new RegExp("(?:https?:\\/\\/)?(?:www\\.)?(?:youtube\\.com|youtu\\.be|youtube-nocookie\\.com)(?:\\/embed\\/|\\/watch\\?v=|\\/)([^\\/]+)","g").exec(url)[1];videoId=videoId.split("&")[0],this.videoId=videoId,this.posterImage="https://img.youtube.com/vi/".concat(videoId,"/maxresdefault.jpg");const img=new Image;img.src=this.posterImage,img.onload=()=>{120==img.width&&90==img.height&&(this.posterImage="https://img.youtube.com/vi/".concat(videoId,"/hqdefault.jpg"))};let loadedcaption=!1;var ready=!1,self=this;let hasError=!1;var options={videoId:videoId,width:1080,height:720,playerVars:{autoplay:opts.autoplay||0,hl:M.cfg.language,start:start,end:end,controls:showControls?1:0,showinfo:0,fs:0,iv_load_policy:3,cc_load_policy:0,autohide:1,rel:0,playsinline:1,disablekb:opts.keyboard?0:1,mute:1},events:{onError:function(e){hasError=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:e.data})},onReady:function(e){if((0,_jquery.default)("#video-wrapper").removeClass("d-none"),self.title=e.target.videoTitle,e.target.getDuration()<=0&&""==e.target.videoTitle)return void(0,_event_dispatcher.dispatchEvent)("iv:playerError",{error:"Video not found"});let totaltime=Number(e.target.getDuration().toFixed(2))-self.frequency;if(0==e.target.getDuration()&&(totaltime=.1,self.live=!0),.1!=end||self.live||(end=totaltime),end=end?Math.min(end,totaltime):totaltime,end=Number(end.toFixed(2)),self.end=end,self.totaltime=totaltime,self.duration=self.end-self.start,self.aspectratio=self.ratio(),1==preload&&0==customStart)ready=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node));else{e.target.mute(),e.target.playVideo();let count=0,interval=setInterval((()=>{if(count++,!0===ready)return clearInterval(interval),e.target.pauseVideo(),void e.target.unMute();if(e.target.getCurrentTime()>0||count>6){if(clearInterval(interval),hasError)return;self.live&&(self.start=e.target.getCurrentTime(),self.end=e.target.getCurrentTime()+1),e.target.seekTo(self.start),e.target.pauseVideo(),e.target.unMute(),ready=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node))}}),1e3)}},onAutoplayBlocked:function(e){(0,_jquery.default)(".video-block, #video-block").remove(),!1===ready&&(e.target.unMute(),ready=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerReady",null,document.getElementById(node)))},onStateChange:function(e){if(!1!==ready)switch(self.live||(player.getCurrentTime()<self.start&&(player.seekTo(self.start),player.playVideo()),player.getCurrentTime()>=self.end+self.frequency&&(player.seekTo(self.end-self.frequency),player.playVideo())),e.data){case YT.PlayerState.ENDED:self.ended=!0,self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded");break;case YT.PlayerState.PLAYING:self.paused=!1,self.ended&&(self.ended=!1,(player.getCurrentTime()<self.start||player.getCurrentTime()>=self.end)&&player.seekTo(self.start)),(0,_event_dispatcher.dispatchEvent)("iv:playerPlay"),(0,_event_dispatcher.dispatchEvent)("iv:playerPlaying"),!self.live&&player.getCurrentTime()>=self.end&&(self.ended=!0,self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerEnded"));break;case YT.PlayerState.PAUSED:self.paused=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerPaused");break;case YT.PlayerState.CUED:!self.live&&player.getCurrentTime()>=self.end&&player.seekTo(self.start)}},onPlaybackRateChange:function(e){(0,_event_dispatcher.dispatchEvent)("iv:playerRateChange",{rate:e.data})},onApiChange:function(){let tracks;loadedcaption||(player.loadModule("captions"),loadedcaption=!0),player.setOption("captions","track",{});try{tracks=player.getOption("captions","tracklist")}catch(e){tracks=[]}tracks&&tracks.length>0&&(tracks=tracks.map((track=>({label:track.displayName,code:track.languageCode}))),self.captions=tracks),loadedcaption=!0,(0,_event_dispatcher.dispatchEvent)("iv:playerLoaded",{tracks:tracks})}}};if(url.includes("youtube-nocookie")&&(options.host="https://www.youtube-nocookie.com"),window.YT)YT=window.YT||{},player=new YT.Player(node,options);else{var tag=document.createElement("script");tag.src="https://www.youtube.com/iframe_api",tag.async=!0,tag.as="script",tag.rel="preload";var firstScriptTag=document.getElementsByTagName("script")[0];firstScriptTag.parentNode.insertBefore(tag,firstScriptTag),window.onYouTubeIframeAPIReady=function(){YT=window.YT||{},player=new YT.Player(node,options)}}return new Promise((resolve=>{resolve(!0)}))}play(){player.playVideo(),this.paused=!1}pause(){player&&(player.pauseVideo(),this.paused=!0)}stop(starttime){player.seekTo(starttime),player.pauseVideo()}async seek(time){return this.ended=!1,new Promise((resolve=>{player.seekTo(time,!0),(0,_event_dispatcher.dispatchEvent)("iv:playerSeek",{time:time}),resolve(!0)}))}getCurrentTime(){return player.getCurrentTime()}getDuration(){return player.getDuration()}isPaused(){return!!this.paused||player.getPlayerState()==window.YT.PlayerState.PAUSED}isPlaying(){return!this.paused&&player.getPlayerState()==window.YT.PlayerState.PLAYING}isEnded(){return!!this.ended||(player.getPlayerState()==window.YT.PlayerState.ENDED||player.getCurrentTime()>=this.end)}ratio(){return 16/9}destroy(){player.destroy(),(0,_event_dispatcher.dispatchEvent)("iv:playerDestroyed")}getState(){return player.getPlayerState()}setRate(rate){return player.setPlaybackRate(rate),rate}mute(){player.mute()}unMute(){player.unMute(),player.setVolume(100)}isMuted(){return player.isMuted()}originalPlayer(){return player}setCaption(track){player.setOption("captions","track",track?{languageCode:track}:{})}};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=yt.min.js.map