"use strict";(function(root,factory){if(typeof define==="function"&&define.amd){define("pdfjs-web/pdf_presentation_mode",["exports"],factory)}else if(typeof exports!=="undefined"){factory(exports)}else{factory(root.pdfjsWebPDFPresentationMode={})}})(this,function(exports){var DELAY_BEFORE_RESETTING_SWITCH_IN_PROGRESS=1500;var DELAY_BEFORE_HIDING_CONTROLS=3e3;var ACTIVE_SELECTOR="pdfPresentationMode";var CONTROLS_SELECTOR="pdfPresentationModeControls";var PDFPresentationMode=function PDFPresentationModeClosure(){function PDFPresentationMode(options){this.container=options.container;this.viewer=options.viewer||options.container.firstElementChild;this.pdfViewer=options.pdfViewer;this.eventBus=options.eventBus;var contextMenuItems=options.contextMenuItems||null;this.active=false;this.args=null;this.contextMenuOpen=false;this.mouseScrollTimeStamp=0;this.mouseScrollDelta=0;if(contextMenuItems){contextMenuItems.contextFirstPage.addEventListener("click",function PDFPresentationMode_contextFirstPageClick(e){this.contextMenuOpen=false;this.eventBus.dispatch("firstpage")}.bind(this));contextMenuItems.contextLastPage.addEventListener("click",function PDFPresentationMode_contextLastPageClick(e){this.contextMenuOpen=false;this.eventBus.dispatch("lastpage")}.bind(this));contextMenuItems.contextPageRotateCw.addEventListener("click",function PDFPresentationMode_contextPageRotateCwClick(e){this.contextMenuOpen=false;this.eventBus.dispatch("rotatecw")}.bind(this));contextMenuItems.contextPageRotateCcw.addEventListener("click",function PDFPresentationMode_contextPageRotateCcwClick(e){this.contextMenuOpen=false;this.eventBus.dispatch("rotateccw")}.bind(this))}}PDFPresentationMode.prototype={request:function PDFPresentationMode_request(){if(this.switchInProgress||this.active||!this.viewer.hasChildNodes()){return false}this._addFullscreenChangeListeners();this._setSwitchInProgress();this._notifyStateChange();if(this.container.requestFullscreen){this.container.requestFullscreen()}else if(this.container.mozRequestFullScreen){this.container.mozRequestFullScreen()}else if(this.container.webkitRequestFullscreen){this.container.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT)}else if(this.container.msRequestFullscreen){this.container.msRequestFullscreen()}else{return false}this.args={page:this.pdfViewer.currentPageNumber,previousScale:this.pdfViewer.currentScaleValue};return true},mouseScroll:function PDFPresentationMode_mouseScroll(delta){if(!this.active){return}var MOUSE_SCROLL_COOLDOWN_TIME=50;var PAGE_SWITCH_THRESHOLD=120;var PageSwitchDirection={UP:-1,DOWN:1};var currentTime=(new Date).getTime();var storedTime=this.mouseScrollTimeStamp;if(currentTime>storedTime&&currentTime-storedTime<MOUSE_SCROLL_COOLDOWN_TIME){return}if(this.mouseScrollDelta>0&&delta<0||this.mouseScrollDelta<0&&delta>0){this._resetMouseScrollState()}this.mouseScrollDelta+=delta;if(Math.abs(this.mouseScrollDelta)>=PAGE_SWITCH_THRESHOLD){var pageSwitchDirection=this.mouseScrollDelta>0?PageSwitchDirection.UP:PageSwitchDirection.DOWN;var page=this.pdfViewer.currentPageNumber;this._resetMouseScrollState();if(page===1&&pageSwitchDirection===PageSwitchDirection.UP||page===this.pdfViewer.pagesCount&&pageSwitchDirection===PageSwitchDirection.DOWN){return}this.pdfViewer.currentPageNumber=page+pageSwitchDirection;this.mouseScrollTimeStamp=currentTime}},get isFullscreen(){return!!(document.fullscreenElement||document.mozFullScreen||document.webkitIsFullScreen||document.msFullscreenElement)},_notifyStateChange:function PDFPresentationMode_notifyStateChange(){this.eventBus.dispatch("presentationmodechanged",{source:this,active:this.active,switchInProgress:!!this.switchInProgress})},_setSwitchInProgress:function PDFPresentationMode_setSwitchInProgress(){if(this.switchInProgress){clearTimeout(this.switchInProgress)}this.switchInProgress=setTimeout(function switchInProgressTimeout(){this._removeFullscreenChangeListeners();delete this.switchInProgress;this._notifyStateChange()}.bind(this),DELAY_BEFORE_RESETTING_SWITCH_IN_PROGRESS)},_resetSwitchInProgress:function PDFPresentationMode_resetSwitchInProgress(){if(this.switchInProgress){clearTimeout(this.switchInProgress);delete this.switchInProgress}},_enter:function PDFPresentationMode_enter(){this.active=true;this._resetSwitchInProgress();this._notifyStateChange();this.container.classList.add(ACTIVE_SELECTOR);setTimeout(function enterPresentationModeTimeout(){this.pdfViewer.currentPageNumber=this.args.page;this.pdfViewer.currentScaleValue="page-fit"}.bind(this),0);this._addWindowListeners();this._showControls();this.contextMenuOpen=false;this.container.setAttribute("contextmenu","viewerContextMenu");window.getSelection().removeAllRanges()},_exit:function PDFPresentationMode_exit(){var page=this.pdfViewer.currentPageNumber;this.container.classList.remove(ACTIVE_SELECTOR);setTimeout(function exitPresentationModeTimeout(){this.active=false;this._removeFullscreenChangeListeners();this._notifyStateChange();this.pdfViewer.currentScaleValue=this.args.previousScale;this.pdfViewer.currentPageNumber=page;this.args=null}.bind(this),0);this._removeWindowListeners();this._hideControls();this._resetMouseScrollState();this.container.removeAttribute("contextmenu");this.contextMenuOpen=false},_mouseDown:function PDFPresentationMode_mouseDown(evt){if(this.contextMenuOpen){this.contextMenuOpen=false;evt.preventDefault();return}if(evt.button===0){var isInternalLink=evt.target.href&&evt.target.classList.contains("internalLink");if(!isInternalLink){evt.preventDefault();this.pdfViewer.currentPageNumber+=evt.shiftKey?-1:1}}},_contextMenu:function PDFPresentationMode_contextMenu(){this.contextMenuOpen=true},_showControls:function PDFPresentationMode_showControls(){if(this.controlsTimeout){clearTimeout(this.controlsTimeout)}else{this.container.classList.add(CONTROLS_SELECTOR)}this.controlsTimeout=setTimeout(function showControlsTimeout(){this.container.classList.remove(CONTROLS_SELECTOR);delete this.controlsTimeout}.bind(this),DELAY_BEFORE_HIDING_CONTROLS)},_hideControls:function PDFPresentationMode_hideControls(){if(!this.controlsTimeout){return}clearTimeout(this.controlsTimeout);this.container.classList.remove(CONTROLS_SELECTOR);delete this.controlsTimeout},_resetMouseScrollState:function PDFPresentationMode_resetMouseScrollState(){this.mouseScrollTimeStamp=0;this.mouseScrollDelta=0},_addWindowListeners:function PDFPresentationMode_addWindowListeners(){this.showControlsBind=this._showControls.bind(this);this.mouseDownBind=this._mouseDown.bind(this);this.resetMouseScrollStateBind=this._resetMouseScrollState.bind(this);this.contextMenuBind=this._contextMenu.bind(this);window.addEventListener("mousemove",this.showControlsBind);window.addEventListener("mousedown",this.mouseDownBind);window.addEventListener("keydown",this.resetMouseScrollStateBind);window.addEventListener("contextmenu",this.contextMenuBind)},_removeWindowListeners:function PDFPresentationMode_removeWindowListeners(){window.removeEventListener("mousemove",this.showControlsBind);window.removeEventListener("mousedown",this.mouseDownBind);window.removeEventListener("keydown",this.resetMouseScrollStateBind);window.removeEventListener("contextmenu",this.contextMenuBind);delete this.showControlsBind;delete this.mouseDownBind;delete this.resetMouseScrollStateBind;delete this.contextMenuBind},_fullscreenChange:function PDFPresentationMode_fullscreenChange(){if(this.isFullscreen){this._enter()}else{this._exit()}},_addFullscreenChangeListeners:function PDFPresentationMode_addFullscreenChangeListeners(){this.fullscreenChangeBind=this._fullscreenChange.bind(this);window.addEventListener("fullscreenchange",this.fullscreenChangeBind);window.addEventListener("mozfullscreenchange",this.fullscreenChangeBind);window.addEventListener("webkitfullscreenchange",this.fullscreenChangeBind);window.addEventListener("MSFullscreenChange",this.fullscreenChangeBind)},_removeFullscreenChangeListeners:function PDFPresentationMode_removeFullscreenChangeListeners(){window.removeEventListener("fullscreenchange",this.fullscreenChangeBind);window.removeEventListener("mozfullscreenchange",this.fullscreenChangeBind);window.removeEventListener("webkitfullscreenchange",this.fullscreenChangeBind);window.removeEventListener("MSFullscreenChange",this.fullscreenChangeBind);delete this.fullscreenChangeBind}};return PDFPresentationMode}();exports.PDFPresentationMode=PDFPresentationMode});