"use strict";(function(root,factory){if(typeof define==="function"&&define.amd){define("pdfjs-web/pdf_rendering_queue",["exports"],factory)}else if(typeof exports!=="undefined"){factory(exports)}else{factory(root.pdfjsWebPDFRenderingQueue={})}})(this,function(exports){var CLEANUP_TIMEOUT=3e4;var RenderingStates={INITIAL:0,RUNNING:1,PAUSED:2,FINISHED:3};var PDFRenderingQueue=function PDFRenderingQueueClosure(){function PDFRenderingQueue(){this.pdfViewer=null;this.pdfThumbnailViewer=null;this.onIdle=null;this.highestPriorityPage=null;this.idleTimeout=null;this.printing=false;this.isThumbnailViewEnabled=false}PDFRenderingQueue.prototype={setViewer:function PDFRenderingQueue_setViewer(pdfViewer){this.pdfViewer=pdfViewer},setThumbnailViewer:function PDFRenderingQueue_setThumbnailViewer(pdfThumbnailViewer){this.pdfThumbnailViewer=pdfThumbnailViewer},isHighestPriority:function PDFRenderingQueue_isHighestPriority(view){return this.highestPriorityPage===view.renderingId},renderHighestPriority:function PDFRenderingQueue_renderHighestPriority(currentlyVisiblePages){if(this.idleTimeout){clearTimeout(this.idleTimeout);this.idleTimeout=null}if(this.pdfViewer.forceRendering(currentlyVisiblePages)){return}if(this.pdfThumbnailViewer&&this.isThumbnailViewEnabled){if(this.pdfThumbnailViewer.forceRendering()){return}}if(this.printing){return}if(this.onIdle){this.idleTimeout=setTimeout(this.onIdle.bind(this),CLEANUP_TIMEOUT)}},getHighestPriority:function PDFRenderingQueue_getHighestPriority(visible,views,scrolledDown){var visibleViews=visible.views;var numVisible=visibleViews.length;if(numVisible===0){return false}for(var i=0;i<numVisible;++i){var view=visibleViews[i].view;if(!this.isViewFinished(view)){return view}}if(scrolledDown){var nextPageIndex=visible.last.id;if(views[nextPageIndex]&&!this.isViewFinished(views[nextPageIndex])){return views[nextPageIndex]}}else{var previousPageIndex=visible.first.id-2;if(views[previousPageIndex]&&!this.isViewFinished(views[previousPageIndex])){return views[previousPageIndex]}}return null},isViewFinished:function PDFRenderingQueue_isViewFinished(view){return view.renderingState===RenderingStates.FINISHED},renderView:function PDFRenderingQueue_renderView(view){var state=view.renderingState;switch(state){case RenderingStates.FINISHED:return false;case RenderingStates.PAUSED:this.highestPriorityPage=view.renderingId;view.resume();break;case RenderingStates.RUNNING:this.highestPriorityPage=view.renderingId;break;case RenderingStates.INITIAL:this.highestPriorityPage=view.renderingId;var continueRendering=function(){this.renderHighestPriority()}.bind(this);view.draw().then(continueRendering,continueRendering);break}return true}};return PDFRenderingQueue}();exports.RenderingStates=RenderingStates;exports.PDFRenderingQueue=PDFRenderingQueue});