"use strict";(function(root,factory){if(typeof define==="function"&&define.amd){define("pdfjs-web/ui_utils",["exports","pdfjs-web/pdfjs"],factory)}else if(typeof exports!=="undefined"){factory(exports,require("./pdfjs.js"))}else{factory(root.pdfjsWebUIUtils={},root.pdfjsWebPDFJS)}})(this,function(exports,pdfjsLib){var CSS_UNITS=96/72;var DEFAULT_SCALE_VALUE="auto";var DEFAULT_SCALE=1;var UNKNOWN_SCALE=0;var MAX_AUTO_SCALE=1.25;var SCROLLBAR_PADDING=40;var VERTICAL_PADDING=5;var mozL10n=document.mozL10n||document.webL10n;var PDFJS=pdfjsLib.PDFJS;PDFJS.disableFullscreen=PDFJS.disableFullscreen===undefined?false:PDFJS.disableFullscreen;PDFJS.useOnlyCssZoom=PDFJS.useOnlyCssZoom===undefined?false:PDFJS.useOnlyCssZoom;PDFJS.maxCanvasPixels=PDFJS.maxCanvasPixels===undefined?16777216:PDFJS.maxCanvasPixels;PDFJS.disableHistory=PDFJS.disableHistory===undefined?false:PDFJS.disableHistory;PDFJS.disableTextLayer=PDFJS.disableTextLayer===undefined?false:PDFJS.disableTextLayer;PDFJS.ignoreCurrentPositionOnZoom=PDFJS.ignoreCurrentPositionOnZoom===undefined?false:PDFJS.ignoreCurrentPositionOnZoom;PDFJS.locale=PDFJS.locale===undefined?navigator.language:PDFJS.locale;function getOutputScale(ctx){var devicePixelRatio=window.devicePixelRatio||1;var backingStoreRatio=ctx.webkitBackingStorePixelRatio||ctx.mozBackingStorePixelRatio||ctx.msBackingStorePixelRatio||ctx.oBackingStorePixelRatio||ctx.backingStorePixelRatio||1;var pixelRatio=devicePixelRatio/backingStoreRatio;return{sx:pixelRatio,sy:pixelRatio,scaled:pixelRatio!==1}}function scrollIntoView(element,spot,skipOverflowHiddenElements){var parent=element.offsetParent;if(!parent){console.error("offsetParent is not set -- cannot scroll");return}var checkOverflow=skipOverflowHiddenElements||false;var offsetY=element.offsetTop+element.clientTop;var offsetX=element.offsetLeft+element.clientLeft;while(parent.clientHeight===parent.scrollHeight||checkOverflow&&getComputedStyle(parent).overflow==="hidden"){if(parent.dataset._scaleY){offsetY/=parent.dataset._scaleY;offsetX/=parent.dataset._scaleX}offsetY+=parent.offsetTop;offsetX+=parent.offsetLeft;parent=parent.offsetParent;if(!parent){return}}if(spot){if(spot.top!==undefined){offsetY+=spot.top}if(spot.left!==undefined){offsetX+=spot.left;parent.scrollLeft=offsetX}}parent.scrollTop=offsetY}function watchScroll(viewAreaElement,callback){var debounceScroll=function debounceScroll(evt){if(rAF){return}rAF=window.requestAnimationFrame(function viewAreaElementScrolled(){rAF=null;var currentY=viewAreaElement.scrollTop;var lastY=state.lastY;if(currentY!==lastY){state.down=currentY>lastY}state.lastY=currentY;callback(state)})};var state={down:true,lastY:viewAreaElement.scrollTop,_eventHandler:debounceScroll};var rAF=null;viewAreaElement.addEventListener("scroll",debounceScroll,true);return state}function parseQueryString(query){var parts=query.split("&");var params={};for(var i=0,ii=parts.length;i<ii;++i){var param=parts[i].split("=");var key=param[0].toLowerCase();var value=param.length>1?param[1]:null;params[decodeURIComponent(key)]=decodeURIComponent(value)}return params}function binarySearchFirstItem(items,condition){var minIndex=0;var maxIndex=items.length-1;if(items.length===0||!condition(items[maxIndex])){return items.length}if(condition(items[minIndex])){return minIndex}while(minIndex<maxIndex){var currentIndex=minIndex+maxIndex>>1;var currentItem=items[currentIndex];if(condition(currentItem)){maxIndex=currentIndex}else{minIndex=currentIndex+1}}return minIndex}function approximateFraction(x){if(Math.floor(x)===x){return[x,1]}var xinv=1/x;var limit=8;if(xinv>limit){return[1,limit]}else if(Math.floor(xinv)===xinv){return[1,xinv]}var x_=x>1?xinv:x;var a=0,b=1,c=1,d=1;while(true){var p=a+c,q=b+d;if(q>limit){break}if(x_<=p/q){c=p;d=q}else{a=p;b=q}}if(x_-a/b<c/d-x_){return x_===x?[a,b]:[b,a]}else{return x_===x?[c,d]:[d,c]}}function roundToDivide(x,div){var r=x%div;return r===0?x:Math.round(x-r+div)}function getVisibleElements(scrollEl,views,sortByVisibility){var top=scrollEl.scrollTop,bottom=top+scrollEl.clientHeight;var left=scrollEl.scrollLeft,right=left+scrollEl.clientWidth;function isElementBottomBelowViewTop(view){var element=view.div;var elementBottom=element.offsetTop+element.clientTop+element.clientHeight;return elementBottom>top}var visible=[],view,element;var currentHeight,viewHeight,hiddenHeight,percentHeight;var currentWidth,viewWidth;var firstVisibleElementInd=views.length===0?0:binarySearchFirstItem(views,isElementBottomBelowViewTop);for(var i=firstVisibleElementInd,ii=views.length;i<ii;i++){view=views[i];element=view.div;currentHeight=element.offsetTop+element.clientTop;viewHeight=element.clientHeight;if(currentHeight>bottom){break}currentWidth=element.offsetLeft+element.clientLeft;viewWidth=element.clientWidth;if(currentWidth+viewWidth<left||currentWidth>right){continue}hiddenHeight=Math.max(0,top-currentHeight)+Math.max(0,currentHeight+viewHeight-bottom);percentHeight=(viewHeight-hiddenHeight)*100/viewHeight|0;visible.push({id:view.id,x:currentWidth,y:currentHeight,view:view,percent:percentHeight})}var first=visible[0];var last=visible[visible.length-1];if(sortByVisibility){visible.sort(function(a,b){var pc=a.percent-b.percent;if(Math.abs(pc)>.001){return-pc}return a.id-b.id})}return{first:first,last:last,views:visible}}function noContextMenuHandler(e){e.preventDefault()}function getPDFFileNameFromURL(url){var reURI=/^(?:([^:]+:)?\/\/[^\/]+)?([^?#]*)(\?[^#]*)?(#.*)?$/;var reFilename=/[^\/?#=]+\.pdf\b(?!.*\.pdf\b)/i;var splitURI=reURI.exec(url);var suggestedFilename=reFilename.exec(splitURI[1])||reFilename.exec(splitURI[2])||reFilename.exec(splitURI[3]);if(suggestedFilename){suggestedFilename=suggestedFilename[0];if(suggestedFilename.indexOf("%")!==-1){try{suggestedFilename=reFilename.exec(decodeURIComponent(suggestedFilename))[0]}catch(e){}}}return suggestedFilename||"document.pdf"}var EventBus=function EventBusClosure(){function EventBus(){this._listeners=Object.create(null)}EventBus.prototype={on:function EventBus_on(eventName,listener){var eventListeners=this._listeners[eventName];if(!eventListeners){eventListeners=[];this._listeners[eventName]=eventListeners}eventListeners.push(listener)},off:function EventBus_on(eventName,listener){var eventListeners=this._listeners[eventName];var i;if(!eventListeners||(i=eventListeners.indexOf(listener))<0){return}eventListeners.splice(i,1)},dispatch:function EventBus_dispath(eventName){var eventListeners=this._listeners[eventName];if(!eventListeners||eventListeners.length===0){return}var args=Array.prototype.slice.call(arguments,1);eventListeners.slice(0).forEach(function(listener){listener.apply(null,args)})}};return EventBus}();var ProgressBar=function ProgressBarClosure(){function clamp(v,min,max){return Math.min(Math.max(v,min),max)}function ProgressBar(id,opts){this.visible=true;this.div=document.querySelector(id+" .progress");this.bar=this.div.parentNode;this.height=opts.height||100;this.width=opts.width||100;this.units=opts.units||"%";this.div.style.height=this.height+this.units;this.percent=0}ProgressBar.prototype={updateBar:function ProgressBar_updateBar(){if(this._indeterminate){this.div.classList.add("indeterminate");this.div.style.width=this.width+this.units;return}this.div.classList.remove("indeterminate");var progressSize=this.width*this._percent/100;this.div.style.width=progressSize+this.units},get percent(){return this._percent},set percent(val){this._indeterminate=isNaN(val);this._percent=clamp(val,0,100);this.updateBar()},setWidth:function ProgressBar_setWidth(viewer){if(viewer){var container=viewer.parentNode;var scrollbarWidth=container.offsetWidth-viewer.offsetWidth;if(scrollbarWidth>0){this.bar.setAttribute("style","width: calc(100% - "+scrollbarWidth+"px);")}}},hide:function ProgressBar_hide(){if(!this.visible){return}this.visible=false;this.bar.classList.add("hidden");document.body.classList.remove("loadingInProgress")},show:function ProgressBar_show(){if(this.visible){return}this.visible=true;document.body.classList.add("loadingInProgress");this.bar.classList.remove("hidden")}};return ProgressBar}();exports.CSS_UNITS=CSS_UNITS;exports.DEFAULT_SCALE_VALUE=DEFAULT_SCALE_VALUE;exports.DEFAULT_SCALE=DEFAULT_SCALE;exports.UNKNOWN_SCALE=UNKNOWN_SCALE;exports.MAX_AUTO_SCALE=MAX_AUTO_SCALE;exports.SCROLLBAR_PADDING=SCROLLBAR_PADDING;exports.VERTICAL_PADDING=VERTICAL_PADDING;exports.mozL10n=mozL10n;exports.EventBus=EventBus;exports.ProgressBar=ProgressBar;exports.getPDFFileNameFromURL=getPDFFileNameFromURL;exports.noContextMenuHandler=noContextMenuHandler;exports.parseQueryString=parseQueryString;exports.getVisibleElements=getVisibleElements;exports.roundToDivide=roundToDivide;exports.approximateFraction=approximateFraction;exports.getOutputScale=getOutputScale;exports.scrollIntoView=scrollIntoView;exports.watchScroll=watchScroll;exports.binarySearchFirstItem=binarySearchFirstItem});