"use strict";(function(root,factory){if(typeof define==="function"&&define.amd){define("pdfjs/core/ps_parser",["exports","pdfjs/shared/util","pdfjs/core/parser"],factory)}else if(typeof exports!=="undefined"){factory(exports,require("../shared/util.js"),require("./parser.js"))}else{factory(root.pdfjsCorePsParser={},root.pdfjsSharedUtil,root.pdfjsCoreParser)}})(this,function(exports,sharedUtil,coreParser){var error=sharedUtil.error;var EOF=coreParser.EOF;var Lexer=coreParser.Lexer;var PostScriptParser=function PostScriptParserClosure(){function PostScriptParser(lexer){this.lexer=lexer;this.operators=[];this.token=null;this.prev=null}PostScriptParser.prototype={nextToken:function PostScriptParser_nextToken(){this.prev=this.token;this.token=this.lexer.getToken()},accept:function PostScriptParser_accept(type){if(this.token.type===type){this.nextToken();return true}return false},expect:function PostScriptParser_expect(type){if(this.accept(type)){return true}error("Unexpected symbol: found "+this.token.type+" expected "+type+".")},parse:function PostScriptParser_parse(){this.nextToken();this.expect(PostScriptTokenTypes.LBRACE);this.parseBlock();this.expect(PostScriptTokenTypes.RBRACE);return this.operators},parseBlock:function PostScriptParser_parseBlock(){while(true){if(this.accept(PostScriptTokenTypes.NUMBER)){this.operators.push(this.prev.value)}else if(this.accept(PostScriptTokenTypes.OPERATOR)){this.operators.push(this.prev.value)}else if(this.accept(PostScriptTokenTypes.LBRACE)){this.parseCondition()}else{return}}},parseCondition:function PostScriptParser_parseCondition(){var conditionLocation=this.operators.length;this.operators.push(null,null);this.parseBlock();this.expect(PostScriptTokenTypes.RBRACE);if(this.accept(PostScriptTokenTypes.IF)){this.operators[conditionLocation]=this.operators.length;this.operators[conditionLocation+1]="jz"}else if(this.accept(PostScriptTokenTypes.LBRACE)){var jumpLocation=this.operators.length;this.operators.push(null,null);var endOfTrue=this.operators.length;this.parseBlock();this.expect(PostScriptTokenTypes.RBRACE);this.expect(PostScriptTokenTypes.IFELSE);this.operators[jumpLocation]=this.operators.length;this.operators[jumpLocation+1]="j";this.operators[conditionLocation]=endOfTrue;this.operators[conditionLocation+1]="jz"}else{error("PS Function: error parsing conditional.")}}};return PostScriptParser}();var PostScriptTokenTypes={LBRACE:0,RBRACE:1,NUMBER:2,OPERATOR:3,IF:4,IFELSE:5};var PostScriptToken=function PostScriptTokenClosure(){function PostScriptToken(type,value){this.type=type;this.value=value}var opCache=Object.create(null);PostScriptToken.getOperator=function PostScriptToken_getOperator(op){var opValue=opCache[op];if(opValue){return opValue}return opCache[op]=new PostScriptToken(PostScriptTokenTypes.OPERATOR,op)};PostScriptToken.LBRACE=new PostScriptToken(PostScriptTokenTypes.LBRACE,"{");PostScriptToken.RBRACE=new PostScriptToken(PostScriptTokenTypes.RBRACE,"}");PostScriptToken.IF=new PostScriptToken(PostScriptTokenTypes.IF,"IF");PostScriptToken.IFELSE=new PostScriptToken(PostScriptTokenTypes.IFELSE,"IFELSE");return PostScriptToken}();var PostScriptLexer=function PostScriptLexerClosure(){function PostScriptLexer(stream){this.stream=stream;this.nextChar();this.strBuf=[]}PostScriptLexer.prototype={nextChar:function PostScriptLexer_nextChar(){return this.currentChar=this.stream.getByte()},getToken:function PostScriptLexer_getToken(){var comment=false;var ch=this.currentChar;while(true){if(ch<0){return EOF}if(comment){if(ch===10||ch===13){comment=false}}else if(ch===37){comment=true}else if(!Lexer.isSpace(ch)){break}ch=this.nextChar()}switch(ch|0){case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:case 43:case 45:case 46:return new PostScriptToken(PostScriptTokenTypes.NUMBER,this.getNumber());case 123:this.nextChar();return PostScriptToken.LBRACE;case 125:this.nextChar();return PostScriptToken.RBRACE}var strBuf=this.strBuf;strBuf.length=0;strBuf[0]=String.fromCharCode(ch);while((ch=this.nextChar())>=0&&(ch>=65&&ch<=90||ch>=97&&ch<=122)){strBuf.push(String.fromCharCode(ch))}var str=strBuf.join("");switch(str.toLowerCase()){case"if":return PostScriptToken.IF;case"ifelse":return PostScriptToken.IFELSE;default:return PostScriptToken.getOperator(str)}},getNumber:function PostScriptLexer_getNumber(){var ch=this.currentChar;var strBuf=this.strBuf;strBuf.length=0;strBuf[0]=String.fromCharCode(ch);while((ch=this.nextChar())>=0){if(ch>=48&&ch<=57||ch===45||ch===46){strBuf.push(String.fromCharCode(ch))}else{break}}var value=parseFloat(strBuf.join(""));if(isNaN(value)){error("Invalid floating point number: "+value)}return value}};return PostScriptLexer}();exports.PostScriptLexer=PostScriptLexer;exports.PostScriptParser=PostScriptParser});